/* 
 *  NonEditableAttachedDataKVP.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.DataI;

public class NonEditableAttachedDataKVP extends KVPTabBase {

    public NonEditableAttachedDataKVP() {
        super("KVP");
    }

    @Override
    void update(InteractionDataI data) {
        getTab().setDisable(!data.canGetData());
        getList().clear();

        boolean disable = !data.canGetData();
        getTab().setDisable(disable);

        DataI dataInstance = data.getData();
        if (dataInstance != null) {
            switch (dataInstance.getFormat()) {
                case BIN:
                    getTab().setDisable(true);
                    break;
                case KVP:
                    getTab().setDisable(false);
                    getList().addAll(KVPItem.convertKVPData(data.getData()));
                    break;
                case STR:
                    getTab().setDisable(true);
                    break;
                case UNKNOWN:
                    getTab().setDisable(true);
                    break;
            }
        }
    }
}
